// priority: 100
onEvent('recipes', (event) => {
    //Everything in this first section covers seeds or plant products for garden cloches.
    //Soils are stored in global.js

    //sawdust flooring
    event.shapeless('immersiveengineering:sawdust', ['thermal:sawdust']);

    //Base times for recipes
    let time = {
        tiny: 460,
        low: 560,
        medium: 640,
        high: 800
    };

    //Crop rendertypes, determines what you see in the cloche
    let renderType = {
        generic: 'generic',
        crop: 'crop',
        stacking: 'stacking',
        stem: 'stem',
        chorus: 'chorus',
        hemp: 'hemp'
    }

    //Function Wrap
    //Packs one item into JSON object
    const w = (item) => {
        return {
            'item': item
        };
    }

    //Function Wrap 2
    //Packs an item and its count into JSON object
    const w2 = (item, count) => {
        return {
            'item': item,
            'count': count
        };
    }

    //Function garden cloche
    //Create a recipe for each seed and their soil
    //
    //Example: gardenCloche('minecraft:wheat_seeds',
    //                          [w('minecraft:wheat_seeds'), w2('minecraft:wheat', 2)],
    //                          'minecraft:dirt',
    //                          'minecraft:wheat',
    //                          'crop'
    //                          640);
    const gardenCloche = (input, resultsArray, soil, renderType, cropToRender, baseTime) => {
        event.custom({
            'type': 'immersiveengineering:cloche',
            'results': resultsArray,
            'input': {
                'item': input
            },
            'soil': soil.bundle,
            'time': baseTime * soil.timeModifier,
            'render': {
                'type': renderType,
                'block': cropToRender
            }
        });
    };

    //    ++++++++++   ++++++++++   ++++++++++  ++++++++++  ++++++++++
    //    +            +        +   +        +  +        +  +         
    //    +            +       +    +        +  +       +   +         
    //    +            +      +     +        +  +      +    ++++++++++
    //    +            +++++++      +        +  +++++++              +
    //    +            +      +     +        +  +                    +
    //    ++++++++++   +       +    ++++++++++  +           ++++++++++

    //Crimson Fungus
    gardenCloche('minecraft:crimson_fungus',
        [w('minecraft:crimson_fungus')],
        global.soils.crimson_nylium,
        renderType.generic,
        'minecraft:crimson_fungus',
        time.high
    );

    //Warped Fungus
    gardenCloche('minecraft:warped_fungus',
        [w('minecraft:warped_fungus')],
        global.soils.warped_nylium,
        renderType.generic,
        'minecraft:warped_fungus',
        time.high
    );

    //Glowstone Mushroom Spores
    gardenCloche('thermal:glowstone_mushroom_spores',
        [w2('thermal:glowstone_mushroom_spores', 2)],
        global.soils.phytosoil,
        renderType.crop,
        'thermal:glowstone_mushroom',
        time.high
    );

    //Gunpowder Mushroom Spores
    gardenCloche('thermal:gunpowder_mushroom_spores',
        [w2('thermal:gunpowder_mushroom_spores', 2)],
        global.soils.phytosoil,
        renderType.crop,
        'thermal:gunpowder_mushroom',
        time.high
    );

    //Redstone Mushroom Spores
    gardenCloche('thermal:redstone_mushroom_spores',
        [w2('thermal:redstone_mushroom_spores', 2)],
        global.soils.phytosoil,
        renderType.crop,
        'thermal:redstone_mushroom',
        time.high
    );

    //Slime Mushroom Spores
    gardenCloche('thermal:slime_mushroom_spores',
        [w2('thermal:slime_mushroom_spores', 2)],
        global.soils.phytosoil,
        renderType.crop,
        'thermal:slime_mushroom',
        time.high
    );

    //Soils for Mushrooms
    const MUSHROOM_SOILS = [global.soils.rooted_dirt, global.soils.podzol, global.soils.mycelium, global.soils.mutated_grass, global.soils.phytosoil];
    MUSHROOM_SOILS.forEach((soil) => {
        //Red Mushroom
        gardenCloche('minecraft:red_mushroom',
            [w('minecraft:red_mushroom')],
            soil,
            renderType.generic,
            'minecraft:red_mushroom',
            time.tiny
        );

        //Brown Mushroom
        gardenCloche('minecraft:brown_mushroom',
            [w('minecraft:brown_mushroom')],
            soil,
            renderType.generic,
            'minecraft:brown_mushroom',
            time.tiny
        );

        //Toadstool
        gardenCloche('biomesoplenty:toadstool',
            [w('biomesoplenty:toadstool')],
            soil,
            renderType.generic,
            'biomesoplenty:toadstool',
            time.tiny
        );
    });

    //Tube Coral
    gardenCloche('minecraft:tube_coral_fan',
        [w('minecraft:tube_coral_fan')],
        global.soils.tube_coral,
        renderType.generic,
        'minecraft:tube_coral_fan',
        time.medium
    );

    //Brain Coral
    gardenCloche('minecraft:brain_coral_fan',
        [w('minecraft:brain_coral_fan')],
        global.soils.brain_coral,
        renderType.generic,
        'minecraft:brain_coral_fan',
        time.medium
    );

    //Bubble Coral
    gardenCloche('minecraft:bubble_coral_fan',
        [w('minecraft:bubble_coral_fan')],
        global.soils.bubble_coral,
        renderType.generic,
        'minecraft:bubble_coral_fan',
        time.medium
    );

    //Fire Coral
    gardenCloche('minecraft:fire_coral',
        [w('minecraft:fire_coral')],
        global.soils.fire_coral,
        renderType.generic,
        'minecraft:fire_coral',
        time.medium
    );

    //Horn Coral
    gardenCloche('minecraft:horn_coral',
        [w('minecraft:horn_coral')],
        global.soils.horn_coral,
        renderType.generic,
        'minecraft:horn_coral',
        time.medium
    );

    //Glowshroom
    gardenCloche('biomesoplenty:glowshroom',
        [w('biomesoplenty:glowshroom')],
        global.soils.glowing_moss,
        renderType.generic,
        'biomesoplenty:glowshroom',
        time.tiny
    );

    //Nether Wart
    gardenCloche('minecraft:nether_wart',
        [w2('minecraft:nether_wart', 2)],
        global.soils.soul_sand,
        renderType.crop,
        'minecraft:nether_wart',
        time.high
    );
    gardenCloche('minecraft:nether_wart',
        [w2('minecraft:nether_wart', 2)],
        global.soils.scorched_grass,
        renderType.crop,
        'minecraft:nether_wart',
        time.high
    );
    gardenCloche('minecraft:nether_wart',
        [w2('minecraft:nether_wart', 2)],
        global.soils.suol_snad,
        renderType.crop,
        'minecraft:nether_wart',
        time.high
    );

    //Burning Blossom
    gardenCloche('biomesoplenty:burning_blossom',
        [w('biomesoplenty:burning_blossom')],
        global.soils.netherrack,
        renderType.generic,
        'biomesoplenty:burning_blossom',
        time.medium
    );
    gardenCloche('biomesoplenty:burning_blossom',
        [w('biomesoplenty:burning_blossom')],
        global.soils.scorched_grass,
        renderType.generic,
        'biomesoplenty:burning_blossom',
        time.medium
    );

    //Chorus Flower
    gardenCloche('minecraft:chorus_flower',
        [w2('minecraft:chorus_fruit', 2)],
        global.soils.end_stone,
        renderType.chorus,
        'minecraft:chorus_flower',
        time.tiny
    );
    //Chorus Flower
    gardenCloche('minecraft:chorus_flower',
        [w2('minecraft:chorus_fruit', 2)],
        global.soils.phytosoil,
        renderType.chorus,
        'minecraft:chorus_flower',
        time.tiny
    );

    //Soils for aquatic plants
    const AQUATIC_SOILS = [global.soils.wet_sponge, global.soils.infused_grass];
    AQUATIC_SOILS.forEach((soil) => {
        //Sea Pickle
        gardenCloche('minecraft:sea_pickle',
            [w('minecraft:sea_pickle')],
            soil,
            renderType.generic,
            'minecraft:sea_pickle',
            time.low
        );

        //Rice
        gardenCloche('farmersdelight:rice',
            [w('farmersdelight:rice_panicle')],
            soil,
            renderType.crop,
            'farmersdelight:rice_panicles',
            time.tiny
        );

        //Seagrass
        gardenCloche('minecraft:seagrass',
            [w('minecraft:seagrass')],
            soil,
            renderType.generic,
            'minecraft:seagrass',
            time.low
        );

        //Cattail
        gardenCloche('biomesoplenty:cattail',
            [w('biomesoplenty:cattail')],
            soil,
            renderType.stacking,
            'biomesoplenty:cattail',
            time.medium
        );
    });


    const SUGAR_CANE_SOILS = [global.soils.sand, global.soils.rooted_sand, global.soils.snad, global.soils.red_snad, global.soils.phytosoil,];
    SUGAR_CANE_SOILS.forEach((soil) => {
        gardenCloche('minecraft:sugar_cane',
            [w('minecraft:sugar_cane')],
            soil,
            renderType.stacking,
            'minecraft:sugar_cane',
            time.low
        );
    });

    const CACTUS_SOILS = [global.soils.sand, global.soils.dry_grass, global.soils.snad, global.soils.red_snad, global.soils.phytosoil,];
    CACTUS_SOILS.forEach((soil) => {
        //Cactus (Minecraft)
        gardenCloche('minecraft:cactus',
            [w('minecraft:cactus')],
            soil,
            renderType.stacking,
            'minecraft:cactus',
            time.low
        );

        //Cactus (Floralis)
        global.dyes.forEach((dye) => {
            gardenCloche('floralis:' + dye + '_cactus_seeds',
                [w('floralis:' + dye + '_cactus_seeds'), w2('floralis:' + dye + '_petals', 2), w2('floralis:plant_fibers', 2)],
                soil,
                renderType.generic,
                'floralis:' + dye + '_cactus',
                time.low
            );
        });
    });

    // ___________________________
    // | Normal crop categories  |
    // |________________________ |
    const NORMAL_SOILS = [global.soils.dirt, global.soils.grass_block, global.soils.vivid_grass, global.soils.rich_soil, global.soils.enchanted_soil, global.soils.phytosoil];
    NORMAL_SOILS.forEach((soil) => {
        //Barley
        gardenCloche('thermal:barley_seeds',
            [w('thermal:barley'), w('thermal:barley_seeds')],
            soil,
            renderType.crop,
            'thermal:barley',
            time.medium
        );

        //Corn
        gardenCloche('thermal:corn_seeds',
            [w2('thermal:corn', 2), w2('thermal:corn_seeds', 3)],
            soil,
            renderType.crop,
            'thermal:corn',
            time.medium
        );

        //Flax
        gardenCloche('thermal:flax_seeds',
            [w2('thermal:flax', 2), w2('thermal:flax_seeds', 3)],
            soil,
            renderType.crop,
            'thermal:flax',
            time.medium
        );

        //Onion
        gardenCloche('thermal:onion_seeds',
            [w('thermal:onion'), w('thermal:onion_seeds')],
            soil,
            renderType.crop,
            'thermal:onion',
            time.medium
        );

        //Eggplant
        gardenCloche('thermal:eggplant_seeds',
            [w2('thermal:eggplant', 2)],
            soil,
            renderType.crop,
            'thermal:eggplant',
            time.medium
        );

        //Coffee
        gardenCloche('thermal:coffee_seeds',
            [w2('thermal:coffee', 2)],
            soil,
            renderType.crop,
            'thermal:coffee',
            time.medium
        );

        //Radish
        gardenCloche('thermal:radish_seeds',
            [w('thermal:radish'), w('thermal:radish_seeds')],
            soil,
            renderType.crop,
            'thermal:radish',
            time.medium
        );

        //Rice
        gardenCloche('thermal:rice_seeds',
            [w('thermal:rice'), w('thermal:rice_seeds')],
            soil,
            renderType.crop,
            'thermal:rice',
            time.medium
        );

        //Sadiroot
        gardenCloche('thermal:sadiroot_seeds',
            [w('thermal:sadiroot'), w('thermal:sadiroot_seeds')],
            soil,
            renderType.crop,
            'thermal:sadiroot',
            time.medium
        );

        //Tomato
        gardenCloche('thermal:tomato_seeds',
            [w2('thermal:tomato', 2)],
            soil,
            renderType.crop,
            'thermal:tomato',
            time.medium
        );

        //Hops. It's not implemented though, so it has no crop block.
        gardenCloche('thermal:hops_seeds',
            [w2('thermal:hops')],
            soil,
            renderType.hemp,
            'immersiveengineering:hemp',
            time.medium
        );

        //Strawberry
        gardenCloche('thermal:strawberry_seeds',
            [w2('thermal:strawberry', 2)],
            soil,
            renderType.crop,
            'thermal:strawberry',
            time.medium
        );

        //Peanut
        gardenCloche('thermal:peanut_seeds',
            [w2('thermal:peanut', 2)],
            soil,
            renderType.crop,
            'thermal:peanut',
            time.medium
        );

        //Green Beans
        gardenCloche('thermal:green_bean_seeds',
            [w2('thermal:green_bean', 2)],
            soil,
            renderType.crop,
            'thermal:green_bean',
            time.medium
        );

        //Tea
        gardenCloche('thermal:tea_seeds',
            [w2('thermal:tea', 2)],
            soil,
            renderType.crop,
            'thermal:tea',
            time.medium
        );

        //Bell Pepper
        gardenCloche('thermal:bell_pepper_seeds',
            [w2('thermal:bell_pepper', 2)],
            soil,
            renderType.crop,
            'thermal:bell_pepper',
            time.medium
        );

        //Spinach
        gardenCloche('thermal:spinach_seeds',
            [w('thermal:spinach'), w('thermal:spinach_seeds')],
            soil,
            renderType.crop,
            'thermal:spinach',
            time.medium
        );

        //Frost Melon
        gardenCloche('thermal:frost_melon_seeds',
            [w('thermal:frost_melon')],
            soil,
            renderType.stem,
            'thermal:frost_melon',
            time.high
        );

        //Amaranth
        gardenCloche('thermal:amaranth_seeds',
            [w2('thermal:amaranth', 2), w2('thermal:amaranth_seeds', 3)],
            soil,
            renderType.crop,
            'thermal:amaranth',
            time.medium
        );

        //Melon Seeds
        gardenCloche('minecraft:melon_seeds',
            [w('minecraft:melon')],
            soil,
            renderType.stem,
            'minecraft:melon',
            time.high
        );

        //Pumpkin
        gardenCloche('minecraft:pumpkin_seeds',
            [w('minecraft:pumpkin')],
            soil,
            renderType.stem,
            'minecraft:pumpkin',
            time.high
        );

        global.dyes.forEach((dye) => {
            //Floralis Flowers
            gardenCloche('floralis:' + dye + '_flower_seeds',
                [w('floralis:' + dye + '_flower_seeds'), w('floralis:' + dye + '_petals'), w('floralis:plant_fibers')],
                soil,
                renderType.generic,
                'floralis:' + dye + '_flower',
                time.low
            );

            //Mystical Flowers
            gardenCloche('botania:' + dye + '_petal',
                [w('botania:' + dye + '_petal')],
                soil,
                renderType.generic,
                'botania:' + dye + '_mystical_flower',
                time.high
            );
        });

        //Hemp
        gardenCloche('immersiveengineering:seed',
            [w('immersiveengineering:hemp_fiber'), w('immersiveengineering:seed')],
            soil,
            renderType.hemp,
            'immersiveengineering:hemp',
            time.high
        );

        //Magebloom
        gardenCloche('ars_nouveau:magebloom_crop',
            [w('ars_nouveau:magebloom')],
            soil,
            renderType.crop,
            'ars_nouveau:magebloom_crop',
            time.medium
        );

        //Potato
        gardenCloche('minecraft:potato',
            [w('minecraft:potato', 2)],
            soil,
            renderType.crop,
            'minecraft:potatoes',
            time.high
        );

        //Carrot
        gardenCloche('minecraft:carrot',
            [w('minecraft:carrot', 2)],
            soil,
            renderType.crop,
            'minecraft:carrots',
            time.high
        );

        //Sourceberry
        gardenCloche('ars_nouveau:source_berry',
            [w2('ars_nouveau:source_berry', 2)],
            soil,
            renderType.crop,
            'ars_nouveau:sourceberry_bush',
            time.low
        );

        //Sweet Berry
        gardenCloche('minecraft:sweet_berries',
            [w2('minecraft:sweet_berries', 2)],
            soil,
            renderType.crop,
            'minecraft:sweet_berry_bush',
            time.low
        );

        //Wheat
        gardenCloche('minecraft:wheat_seeds',
            [w('minecraft:wheat_seeds'), w2('minecraft:wheat', 2)],
            soil,
            renderType.crop,
            'minecraft:wheat',
            time.medium
        );

        //Onion
        gardenCloche('farmersdelight:onion',
            [w2('farmersdelight:onion', 2)],
            soil,
            renderType.crop,
            'farmersdelight:onions',
            time.medium
        );

        //Cabbage
        gardenCloche('farmersdelight:cabbage_seeds',
            [w('farmersdelight:cabbage'), w('farmersdelight:cabbage_seeds')],
            soil,
            renderType.crop,
            'farmersdelight:cabbages',
            time.medium
        );

        //Tomato
        gardenCloche('farmersdelight:tomato_seeds',
            [w('farmersdelight:tomato_seeds'), w2('farmersdelight:tomato', 2)],
            soil,
            renderType.crop,
            'farmersdelight:tomatoes',
            time.medium
        );

        //Bamboo
        gardenCloche('minecraft:bamboo',
            [w('minecraft:bamboo')],
            soil,
            renderType.stacking,
            'minecraft:bamboo',
            time.medium
        );

        //Cotton
        gardenCloche('cottonly:cotton_seeds',
            [w('cottonly:cotton_seeds'), w('cottonly:ball')],
            soil,
            renderType.crop,
            'cottonly:cotton_plant',
            time.high
        );

        //Beetroot
        gardenCloche('minecraft:beetroot_seeds',
            [w('minecraft:beetroot_seeds'), w2('minecraft:beetroot', 2)],
            soil,
            renderType.crop,
            'minecraft:beetroots',
            time.high
        );

        //Demon Dream
        gardenCloche('occultism:datura_seeds',
            [w('occultism:datura')],
            soil,
            renderType.crop,
            'occultism:datura',
            time.high
        );
    });

    //Glowflower
    gardenCloche('biomesoplenty:glowflower',
        [w2('minecraft:glowstone_dust', 2)],
        global.soils.enchanted_soil,
        renderType.generic,
        'biomesoplenty:glowflower',
        time.medium
    );

    //Budding crystals and amethyst
    gardenCloche('botania:overgrowth_seed',
        [w('tconstruct:earth_slime_crystal')],
        global.soils.budding_earthslime,
        renderType.generic,
        'tconstruct:earth_slime_crystal_cluster',
        time.high
    );
    gardenCloche('botania:overgrowth_seed',
        [w('tconstruct:sky_slime_crystal')],
        global.soils.budding_skyslime,
        renderType.generic,
        'tconstruct:sky_slime_crystal_cluster',
        time.high
    );
    gardenCloche('botania:overgrowth_seed',
        [w('tconstruct:ichor_slime_crystal')],
        global.soils.budding_ichorslime,
        renderType.generic,
        'tconstruct:ichor_slime_crystal_cluster',
        time.high
    );
    gardenCloche('botania:overgrowth_seed',
        [w('tconstruct:ender_slime_crystal')],
        global.soils.budding_enderslime,
        renderType.generic,
        'tconstruct:ender_slime_crystal_cluster',
        time.high
    );
    gardenCloche('botania:overgrowth_seed',
        [w('minecraft:amethyst_shard')],
        global.soils.budding_amethyst,
        renderType.generic,
        'minecraft:amethyst_cluster',
        time.high
    );

    //Mystical Agriculture crops already have their own system, so they just go here.

    //Ticks to grow a Mystical Agriculture crop in a Garden Cloche. Fixed time since a seed requires a soil of the same tier to grow.
    //90 essence per hour per plant if set to 800 ticks
    const ticksToGrow = 800

    //Iterate through all the tiers. For each section, loop through the seeds for that tier.
    //Make the seeds grow on the farmland assigned to that section only and not any other global.soils.
    global.seedTiers.forEach((tier) => {
        tier.seeds.forEach((seed) => {
            event.recipes
                .immersiveengineeringCloche(
                    ['mysticalagriculture:' + seed + '_essence'],
                    'mysticalagriculture:' + seed + '_seeds',
                    tier.soil,
                    { type: 'crop', block: 'mysticalagriculture:' + seed + '_crop' }
                )
                .time(ticksToGrow);
        })
    })

    //Mineral veins
    //Function that constructs a mineral vein from ores and other parameters
    //Id is required to be able to set a language key in the lang files (kubejs/assets/XYZ/lang)
    const mineral = (ores, dimension, mineralMixWeight, failChance, background, id) => {
        const oresArray = []
        //Parsing of the ores array, which we've simplified for development sake.
        //Format:
        //[
        //  {item: 'minecraft:ancient_debris', chance: 0.5},
        //  {item: 'minecraft:netherrack', chance: 0.5}
        //]
        ores.forEach((ore) => {
            if (ore.tag === undefined)
                oresArray.push({ 'chance': ore.chance, 'output': { 'item': ore.item } })
            else
                oresArray.push({ 'chance': ore.chance, 'output': { 'tag': ore.tag } })
        })
        event.custom({
            'type': 'immersiveengineering:mineral_mix',
            'ores': oresArray,
            'dimensions': [dimension],
            'weight': mineralMixWeight,
            'fail_chance': failChance,
            'sample_background': background
        }).id(id);
    }

    //Iron Vein
    mineral(
        [
            { item: 'minecraft:sand', chance: 0.25 },
            { item: 'minecraft:deepslate_iron_ore', chance: 0.5 },
            { item: 'thermal:deepslate_nickel_ore', chance: 0.25 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'minecraft:deepslate_iron_ore',
        'kubejsadditions:sand_iron_nickel_vein'
    )

    //Gold Vein
    mineral(
        [
            { item: 'biomesoplenty:black_sand', chance: 0.25 },
            { item: 'minecraft:deepslate_gold_ore', chance: 0.5 },
            { item: 'create:ochrum', chance: 0.25 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'minecraft:deepslate_gold_ore',
        'kubejsadditions:blacksand_gold_ochrum_vein'
    )

    //Redstone Vein
    mineral(
        [
            { item: 'minecraft:red_sand', chance: 0.4 },
            { item: 'minecraft:deepslate_redstone_ore', chance: 0.4 },
            { item: 'create:crimsite', chance: 0.2 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'minecraft:deepslate_redstone_ore',
        'kubejsadditions:redsand_redstone_crimsite_vein'
    )

    //Aluminum Vein
    mineral(
        [
            { item: 'immersiveengineering:deepslate_ore_aluminum', chance: 0.4 },
            { item: 'minecraft:deepslate_lapis_ore', chance: 0.35 },
            { item: 'minecraft:calcite', chance: 0.25 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'immersiveengineering:deepslate_ore_aluminum',
        'kubejsadditions:aluminum_lapis_calcite_vein'
    )

    //Coal Vein
    mineral(
        [
            { item: 'biomesoplenty:orange_sand', chance: 0.25 },
            { item: 'minecraft:coal_ore', chance: 0.6 },
            { item: 'minecraft:diamond_ore', chance: 0.15 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'minecraft:coal_ore',
        'kubejsadditions:orangesand_coal_diamond_vein'
    )

    //Copper Vein
    mineral(
        [
            { item: 'quark:limestone', chance: 0.2 },
            { item: 'minecraft:copper_ore', chance: 0.6 },
            { item: 'create:veridium', chance: 0.2 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'minecraft:copper_ore',
        'kubejsadditions:limestone_copper_veridium_vein'
    )

    //Zinc Vein
    mineral(
        [
            { item: 'biomesoplenty:white_sand', chance: 0.25 },
            { item: 'create:zinc_ore', chance: 0.5 },
            { item: 'create:asurine', chance: 0.25 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'create:zinc_ore',
        'kubejsadditions:whitesand_zinc_asurine_vein'
    )

    //Lead/Silver Vein
    mineral(
        [
            { item: 'thermal:deepslate_lead_ore', chance: 0.4 },
            { item: 'thermal:deepslate_silver_ore', chance: 0.4 },
            { item: 'minecraft:andesite', chance: 0.2 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'thermal:deepslate_lead_ore',
        'kubejsadditions:lead_silver_andesite_vein'
    )

    //Uranium Vein
    mineral(
        [
            { item: 'mekanism:deepslate_uranium_ore', chance: 0.5 },
            { item: 'thermal:deepslate_lead_ore', chance: 0.1 },
            { item: 'minecraft:granite', chance: 0.4 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'mekanism:deepslate_uranium_ore',
        'kubejsadditions:uranium_lead_granite_vein'
    )

    //Prosperity Vein
    mineral(
        [
            { item: 'mysticalagriculture:deepslate_prosperity_ore', chance: 0.4 },
            { item: 'malum:deepslate_soulstone_ore', chance: 0.2 },
            { item: 'minecraft:diorite', chance: 0.4 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'mysticalagriculture:deepslate_prosperity_ore',
        'kubejsadditions:prosperity_soulstone_diorite_vein'
    )

    //Diamond Vein
    mineral(
        [
            { item: 'minecraft:deepslate_diamond_ore', chance: 0.4 },
            { item: 'create:scorchia', chance: 0.55 },
            { item: 'minecraft:coal_block', chance: 0.05 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'minecraft:deepslate_diamond_ore',
        'kubejsadditions:diamond_scorchia_coal_vein'
    )

    //Emerald Vein
    mineral(
        [
            { item: 'minecraft:emerald_ore', chance: 0.4 },
            { item: 'minecraft:gravel', chance: 0.5 },
            { item: 'immersiveengineering:ore_aluminum', chance: 0.1 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'minecraft:emerald_ore',
        'kubejsadditions:emerald_gravel_aluminum_vein'
    )

    //Overworld Stone Vein
    mineral(
        [
            { item: 'minecraft:stone', chance: 0.5 },
            { item: 'minecraft:deepslate', chance: 0.4 },
            { item: 'minecraft:tuff', chance: 0.1 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'minecraft:stone',
        'kubejsadditions:stone_deepslate_tuff_vein'
    )

    //Quartz Vein
    mineral(
        [
            { item: 'minecraft:netherrack', chance: 0.4 },
            { item: 'minecraft:nether_quartz_ore', chance: 0.347 },
            { item: 'malum:blazing_quartz_ore', chance: 0.25 },
            { item: 'minecraft:ancient_debris', chance: 0.003 }
        ],
        'minecraft:the_nether',
        3,
        0.0,
        'minecraft:nether_quartz_ore',
        'kubejsadditions:nether_quartz_blazing_vein'
    )

    //Gold Vein
    mineral(
        [
            { item: 'minecraft:netherrack', chance: 0.4 },
            { item: 'minecraft:nether_gold_ore', chance: 0.5 },
            { item: 'tconstruct:cobalt_ore', chance: 0.097 },
            { item: 'minecraft:ancient_debris', chance: 0.003 }
        ],
        'minecraft:the_nether',
        2,
        0.0,
        'minecraft:nether_gold_ore',
        'kubejsadditions:nether_gold_cobalt_vein'
    )

    //Elementary Ores Nether
    mineral(
        [
            { item: 'minecraft:netherrack', chance: 0.4 },
            { item: 'elementaryores:ore_iron_nether', chance: 0.35 },
            { item: 'elementaryores:ore_lapis_nether', chance: 0.24 },
            { item: 'elementaryores:ore_ghast_nether', chance: 0.01 }
        ],
        'minecraft:the_nether',
        1,
        0.0,
        'elementaryores:ore_iron_nether',
        'kubejsadditions:nether_elementary_ores'
    )

    //Iesnium Ore Nether
    mineral(
        [
            { item: 'occultism:iesnium_ore', chance: 0.4 },
            { item: 'occultism:otherstone', chance: 0.4 },
            { item: 'minecraft:netherrack', chance: 0.2 }
        ],
        'minecraft:the_nether',
        1,
        0.0,
        'occultism:iesnium_ore',
        'kubejsadditions:iesnium_otherstone_netherrack_vein'
    )

    //Dimensional Stone
    mineral(
        [
            { item: 'minecraft:end_stone', chance: 0.4 },
            { item: 'rftoolsbase:dimensionalshard_end', chance: 0.3 },
            { item: 'elementaryores:ore_ender_end', chance: 0.3 }
        ],
        'minecraft:the_end',
        3,
        0.0,
        'minecraft:end_stone',
        'kubejsadditions:end_dimensionalshard_vein'
    )

    //End Redstone
    mineral(
        [
            { item: 'minecraft:end_stone', chance: 0.4 },
            { item: 'rftoolsbase:dimensionalshard_end', chance: 0.2 },
            { item: 'elementaryores:ore_redstone_end', chance: 0.4 }
        ],
        'minecraft:the_end',
        2,
        0.0,
        'elementaryores:ore_redstone_end',
        'kubejsadditions:end_redstone_vein'
    )

    //End Diamond
    mineral(
        [
            { item: 'minecraft:end_stone', chance: 0.6 },
            { item: 'elementaryores:ore_diamond_end', chance: 0.25 },
            { item: 'elementaryores:ore_ender_end', chance: 0.15 }
        ],
        'minecraft:the_end',
        1,
        0.0,
        'elementaryores:ore_diamond_end',
        'kubejsadditions:end_diamond_vein'
    )

    //Osmium Vein
    mineral(
        [
            { item: 'biomesoplenty:black_sand', chance: 0.25 },
            { item: 'mekanism:deepslate_osmium_ore', chance: 0.5 },
            { item: 'thermal:deepslate_nickel_ore', chance: 0.25 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'mekanism:deepslate_osmium_ore',
        'kubejsadditions:blacksand_osmium_nickel_vein'
    )

    //Tin Vein
    mineral(
        [
            { item: 'thermal:tin_ore', chance: 0.5 },
            { item: 'mekanism:fluorite_ore', chance: 0.1 },
            { item: 'minecraft:granite', chance: 0.4 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'thermal:tin_ore',
        'kubejsadditions:tin_fluorite_granite_vein'
    )

    //Fluorite Vein
    mineral(
        [
            { item: 'minecraft:calcite', chance: 0.3 },
            { item: 'thermal:deepslate_silver_ore', chance: 0.15 },
            { item: 'immersiveengineering:deepslate_ore_lead', chance: 0.15 },
            { item: 'mekanism:deepslate_fluorite_ore', chance: 0.4 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'mekanism:deepslate_fluorite_ore',
        'kubejsadditions:fluorite_galena_calcite_vein'
    )

    //Aquamarine
    mineral(
        [
            { item: 'minecraft:granite', chance: 0.3 },
            { item: 'hearthstones:aquamarine_ore', chance: 0.6 },
            { item: 'rftoolsbase:dimensionalshard_overworld', chance: 0.1 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'hearthstones:aquamarine_ore',
        'kubejsadditions:aquamarine_dim_vein'
    )

    //Sapphire
    mineral(
        [
            { item: 'thermal:deepslate_sapphire_ore', chance: 0.7 },
            { item: 'thermal:deepslate_apatite_ore', chance: 0.15 },
            { item: 'mekanism:deepslate_uranium_ore', chance: 0.15 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'thermal:deepslate_sapphire_ore',
        'kubejsadditions:sapphire_apatite_ura_vein'
    )

    //Sulfur & Niter
    mineral(
        [
            { item: 'thermal:sulfur_ore', chance: 0.4 },
            { item: 'thermal:niter_ore', chance: 0.4 },
            { item: 'mekanism:block_salt', chance: 0.2 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'thermal:sulfur_ore',
        'kubejsadditions:sulfur_niter_salt_vein'
    )

    //Ruby
    mineral(
        [
            { item: 'thermal:deepslate_ruby_ore', chance: 0.7 },
            { item: 'thermal:deepslate_cinnabar_ore', chance: 0.15 },
            { item: 'minecraft:gravel', chance: 0.15 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'thermal:deepslate_ruby_ore',
        'kubejsadditions:ruby_cinn_gravel_vein'
    )

    //Brilliant Moss
    mineral(
        [
            { item: 'minecraft:moss_block', chance: 0.4 },
            { item: 'malum:brilliant_deepslate', chance: 0.4 },
            { item: 'ae2:deepslate_quartz_ore', chance: 0.2 }
        ],
        'minecraft:overworld',
        1,
        0.0,
        'malum:brilliant_deepslate',
        'kubejsadditions:brilliant_moss_quartz_vein'
    )


    //Normal recipe stuff

    //Fix dupe introduced by Quark changing nether wart block recipe
    event.recipes.immersiveengineeringCrusher('4x minecraft:nether_wart', 'minecraft:nether_wart_block').id('immersiveengineering:crusher/nether_wart')
});


